--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Products
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function DoOne(i)
	i.usetime = gSim.weeks
	i.inventory = i.inventory + 10
	if not i.known then
		i:EnableRecipe()
		local label = "+ "..GetString(i.name)
		SetLabel(i.name, label)
	end

	gSim:QueueMessage("Debug: "..tostring(i.name))
	gSim:InventoryChanged()
end

local function DoAll()
	for i in LItem:AllProducts() do
		i.usetime = gSim.weeks
		i.inventory = i.inventory + 10
		i:EnableRecipe()
	end
	gSim:QueueMessage("Debug: All Products")
	gSim:InventoryChanged()
end

local function CloseMenu()
	gSim:FlushMessages()
	CloseWindow()
end

-------------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

table.insert(menu, DevMenuItem { x=x,y=y, w=150, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2
	
table.insert(menu, DevMenuItem { x=x,y=y, w=100, label="#-ALL-", command=function() DoAll() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
	
for ing in LItem:AllProducts() do
	local i = ing
	local label = GetString(ing.name)
	if i.known then label = "#+ "..label
	else label = "#- "..label
	end
	table.insert(menu, DevMenuItem { x=x,y=y, w=230, name=i.name, label=label, command=function() DoOne(i) end })
	y = y + bsgFontHeight(devfont) + 2
	if y > ui.devScreenHeight - 30 then
		x = x + 230
		y = 0
	end
end
	
-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
